<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Content
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Content\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Deserialize;
use Twilio\Rest\Content\V1\Content\ApprovalCreateList;
use Twilio\Rest\Content\V1\Content\ApprovalFetchList;


/**
 * @property \DateTime|null $dateCreated
 * @property \DateTime|null $dateUpdated
 * @property string|null $sid
 * @property string|null $accountSid
 * @property string|null $friendlyName
 * @property string|null $language
 * @property array|null $variables
 * @property array|null $types
 * @property string|null $url
 * @property array|null $links
 */
class ContentInstance extends InstanceResource
{
    protected $_approvalCreate;
    protected $_approvalFetch;

    /**
     * Initialize the ContentInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $sid The Twilio-provided string that uniquely identifies the Content resource to fetch.
     */
    public function __construct(Version $version, array $payload, ?string $sid = null)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'dateUpdated' => Deserialize::dateTime(Values::array_get($payload, 'date_updated')),
            'sid' => Values::array_get($payload, 'sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'friendlyName' => Values::array_get($payload, 'friendly_name'),
            'language' => Values::array_get($payload, 'language'),
            'variables' => Values::array_get($payload, 'variables'),
            'types' => Values::array_get($payload, 'types'),
            'url' => Values::array_get($payload, 'url'),
            'links' => Values::array_get($payload, 'links'),
        ];

        $this->solution = ['sid' => $sid ?: $this->properties['sid'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return ContentContext Context for this ContentInstance
     */
    protected function proxy(): ContentContext
    {
        if (!$this->context) {
            $this->context = new ContentContext(
                $this->version,
                $this->solution['sid']
            );
        }

        return $this->context;
    }

    /**
     * Delete the ContentInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {

        return $this->proxy()->delete();
    }

    /**
     * Fetch the ContentInstance
     *
     * @return ContentInstance Fetched ContentInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ContentInstance
    {

        return $this->proxy()->fetch();
    }

    /**
     * Update the ContentInstance
     *
     * @param ContentUpdateRequest $contentUpdateRequest
     * @return ContentInstance Updated ContentInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(ContentUpdateRequest $contentUpdateRequest): ContentInstance
    {

        return $this->proxy()->update($contentUpdateRequest);
    }

    /**
     * Access the approvalCreate
     */
    protected function getApprovalCreate(): ApprovalCreateList
    {
        return $this->proxy()->approvalCreate;
    }

    /**
     * Access the approvalFetch
     */
    protected function getApprovalFetch(): ApprovalFetchList
    {
        return $this->proxy()->approvalFetch;
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Content.V1.ContentInstance ' . \implode(' ', $context) . ']';
    }
}

