<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ToolResults;

class ListStepThumbnailsResponse extends \Google\Collection
{
  protected $collection_key = 'thumbnails';
  /**
   * A continuation token to resume the query at the next item. If set,
   * indicates that there are more thumbnails to read, by calling list again
   * with this value in the page_token field.
   *
   * @var string
   */
  public $nextPageToken;
  protected $thumbnailsType = Image::class;
  protected $thumbnailsDataType = 'array';

  /**
   * A continuation token to resume the query at the next item. If set,
   * indicates that there are more thumbnails to read, by calling list again
   * with this value in the page_token field.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * A list of image data. Images are returned in a deterministic order; they
   * are ordered by these factors, in order of importance: * First, by their
   * associated test case. Images without a test case are considered greater
   * than images with one. * Second, by their creation time. Images without a
   * creation time are greater than images with one. * Third, by the order in
   * which they were added to the step (by calls to CreateStep or UpdateStep).
   *
   * @param Image[] $thumbnails
   */
  public function setThumbnails($thumbnails)
  {
    $this->thumbnails = $thumbnails;
  }
  /**
   * @return Image[]
   */
  public function getThumbnails()
  {
    return $this->thumbnails;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListStepThumbnailsResponse::class, 'Google_Service_ToolResults_ListStepThumbnailsResponse');
