<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1betaControlPromoteAction extends \Google\Model
{
  /**
   * Required. Data store with which this promotion is attached to.
   *
   * @var string
   */
  public $dataStore;
  protected $searchLinkPromotionType = GoogleCloudDiscoveryengineV1betaSearchLinkPromotion::class;
  protected $searchLinkPromotionDataType = '';

  /**
   * Required. Data store with which this promotion is attached to.
   *
   * @param string $dataStore
   */
  public function setDataStore($dataStore)
  {
    $this->dataStore = $dataStore;
  }
  /**
   * @return string
   */
  public function getDataStore()
  {
    return $this->dataStore;
  }
  /**
   * Required. Promotion attached to this action.
   *
   * @param GoogleCloudDiscoveryengineV1betaSearchLinkPromotion $searchLinkPromotion
   */
  public function setSearchLinkPromotion(GoogleCloudDiscoveryengineV1betaSearchLinkPromotion $searchLinkPromotion)
  {
    $this->searchLinkPromotion = $searchLinkPromotion;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1betaSearchLinkPromotion
   */
  public function getSearchLinkPromotion()
  {
    return $this->searchLinkPromotion;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1betaControlPromoteAction::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1betaControlPromoteAction');
