<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect extends \Google\Model
{
  /**
   * Confidence of detected defect. Range `[0, 1]` where `1` indicates strong
   * confidence that the defect exists.
   *
   * @var float
   */
  public $confidence;
  /**
   * Name of the defect type. Supported values are: - `quality/defect_blurry` -
   * `quality/defect_noisy` - `quality/defect_dark` - `quality/defect_faint` -
   * `quality/defect_text_too_small` - `quality/defect_document_cutoff` -
   * `quality/defect_text_cutoff` - `quality/defect_glare`
   *
   * @var string
   */
  public $type;

  /**
   * Confidence of detected defect. Range `[0, 1]` where `1` indicates strong
   * confidence that the defect exists.
   *
   * @param float $confidence
   */
  public function setConfidence($confidence)
  {
    $this->confidence = $confidence;
  }
  /**
   * @return float
   */
  public function getConfidence()
  {
    return $this->confidence;
  }
  /**
   * Name of the defect type. Supported values are: - `quality/defect_blurry` -
   * `quality/defect_noisy` - `quality/defect_dark` - `quality/defect_faint` -
   * `quality/defect_text_too_small` - `quality/defect_document_cutoff` -
   * `quality/defect_text_cutoff` - `quality/defect_glare`
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect::class, 'Google_Service_Contentwarehouse_GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect');
