<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Numbers\V3;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Serialize;


class HostedNumberOrderList extends ListResource
    {
    /**
     * Construct the HostedNumberOrderList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/HostedNumbers/HostedNumberOrders';
    }

    /**
     * Create the HostedNumberOrderInstance
     *
     * @param string $phoneNumber The number to host in [+E.164](https://en.wikipedia.org/wiki/E.164) format
     * @param bool $smsCapability Used to specify that the SMS capability will be hosted on Twilio's platform.
     * @param array|Options $options Optional Arguments
     * @return HostedNumberOrderInstance Created HostedNumberOrderInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $phoneNumber, bool $smsCapability, array $options = []): HostedNumberOrderInstance
    {

        $options = new Values($options);

        $data = Values::of([
            'phoneNumber' =>
                $phoneNumber,
            'smsCapability' =>
                Serialize::booleanToString($smsCapability),
            'accountSid' =>
                $options['accountSid'],
            'friendlyName' =>
                $options['friendlyName'],
            'uniqueName' =>
                $options['uniqueName'],
            'ccEmails' =>
                Serialize::map($options['ccEmails'], function ($e) { return $e; }),
            'smsUrl' =>
                $options['smsUrl'],
            'smsMethod' =>
                $options['smsMethod'],
            'smsFallbackUrl' =>
                $options['smsFallbackUrl'],
            'smsFallbackMethod' =>
                $options['smsFallbackMethod'],
            'statusCallbackUrl' =>
                $options['statusCallbackUrl'],
            'statusCallbackMethod' =>
                $options['statusCallbackMethod'],
            'smsApplicationSid' =>
                $options['smsApplicationSid'],
            'addressSid' =>
                $options['addressSid'],
            'email' =>
                $options['email'],
            'verificationType' =>
                $options['verificationType'],
            'verificationDocumentSid' =>
                $options['verificationDocumentSid'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        $payload = $this->version->create('POST', $this->uri, [], $data, $headers);

        return new HostedNumberOrderInstance(
            $this->version,
            $payload
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Numbers.V3.HostedNumberOrderList]';
    }
}
