<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Testing;

class ManualSharding extends \Google\Collection
{
  protected $collection_key = 'testTargetsForShard';
  protected $testTargetsForShardType = TestTargetsForShard::class;
  protected $testTargetsForShardDataType = 'array';

  /**
   * Required. Group of packages, classes, and/or test methods to be run for
   * each manually-created shard. You must specify at least one shard if this
   * field is present. When you select one or more physical devices, the number
   * of repeated test_targets_for_shard must be <= 50. When you select one or
   * more ARM virtual devices, it must be <= 200. When you select only x86
   * virtual devices, it must be <= 500.
   *
   * @param TestTargetsForShard[] $testTargetsForShard
   */
  public function setTestTargetsForShard($testTargetsForShard)
  {
    $this->testTargetsForShard = $testTargetsForShard;
  }
  /**
   * @return TestTargetsForShard[]
   */
  public function getTestTargetsForShard()
  {
    return $this->testTargetsForShard;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ManualSharding::class, 'Google_Service_Testing_ManualSharding');
