<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\RealTimeBidding;

class HtmlContent extends \Google\Model
{
  /**
   * The height of the HTML snippet in pixels. Can be used to filter the
   * response of the creatives.list method.
   *
   * @var int
   */
  public $height;
  /**
   * The HTML snippet that displays the ad when inserted in the web page.
   *
   * @var string
   */
  public $snippet;
  /**
   * The width of the HTML snippet in pixels. Can be used to filter the response
   * of the creatives.list method.
   *
   * @var int
   */
  public $width;

  /**
   * The height of the HTML snippet in pixels. Can be used to filter the
   * response of the creatives.list method.
   *
   * @param int $height
   */
  public function setHeight($height)
  {
    $this->height = $height;
  }
  /**
   * @return int
   */
  public function getHeight()
  {
    return $this->height;
  }
  /**
   * The HTML snippet that displays the ad when inserted in the web page.
   *
   * @param string $snippet
   */
  public function setSnippet($snippet)
  {
    $this->snippet = $snippet;
  }
  /**
   * @return string
   */
  public function getSnippet()
  {
    return $this->snippet;
  }
  /**
   * The width of the HTML snippet in pixels. Can be used to filter the response
   * of the creatives.list method.
   *
   * @param int $width
   */
  public function setWidth($width)
  {
    $this->width = $width;
  }
  /**
   * @return int
   */
  public function getWidth()
  {
    return $this->width;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(HtmlContent::class, 'Google_Service_RealTimeBidding_HtmlContent');
