<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dns;

class OperationDnsKeyContext extends \Google\Model
{
  protected $newValueType = DnsKey::class;
  protected $newValueDataType = '';
  protected $oldValueType = DnsKey::class;
  protected $oldValueDataType = '';

  /**
   * The post-operation DnsKey resource.
   *
   * @param DnsKey $newValue
   */
  public function setNewValue(DnsKey $newValue)
  {
    $this->newValue = $newValue;
  }
  /**
   * @return DnsKey
   */
  public function getNewValue()
  {
    return $this->newValue;
  }
  /**
   * The pre-operation DnsKey resource.
   *
   * @param DnsKey $oldValue
   */
  public function setOldValue(DnsKey $oldValue)
  {
    $this->oldValue = $oldValue;
  }
  /**
   * @return DnsKey
   */
  public function getOldValue()
  {
    return $this->oldValue;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OperationDnsKeyContext::class, 'Google_Service_Dns_OperationDnsKeyContext');
