<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Directory;

class Members extends \Google\Collection
{
  protected $collection_key = 'members';
  /**
   * ETag of the resource.
   *
   * @var string
   */
  public $etag;
  /**
   * Kind of resource this is.
   *
   * @var string
   */
  public $kind;
  protected $membersType = Member::class;
  protected $membersDataType = 'array';
  /**
   * Token used to access next page of this result.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * ETag of the resource.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Kind of resource this is.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A list of member objects.
   *
   * @param Member[] $members
   */
  public function setMembers($members)
  {
    $this->members = $members;
  }
  /**
   * @return Member[]
   */
  public function getMembers()
  {
    return $this->members;
  }
  /**
   * Token used to access next page of this result.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Members::class, 'Google_Service_Directory_Members');
